package ga.core.individual.population;

import ga.core.individual.IClusterableIndividual;

/**
 * Interface for populations that do clustering.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IClusterPopulation<T extends IClusterableIndividual<T>>
    extends IPopulation<T> {

  /**
   * Divides the population into clusters.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void doClustering();

  /**
   * Searches for the cluster containing the given individual and assigns
   * fitness to all individuals in the cluster.
   * 
   * @param ind
   *          Individual that has fitness.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void assignFitness(T ind);

  /**
   * Assign fitness in all clusters. Requires the centers of the clusters to
   * have fitness.
   * 
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void assignFitness();
}
